﻿var projectMenu = {
    context: $("#main-header"),
    getProjectId: function () {
        return $("#survey-block", projectMenu.context).attr("data-projectId");
    },
    parseProject: function () {
        if ($("#project-data", projectMenu.context).length > 0)
            projectMenu.project = JSON.parse($("#project-data", projectMenu.context).val());
    },
    project: undefined,
    projects: [],
    bindEvents: function () {
        var projectId = projectMenu.getProjectId();

        projectMenu.context.on("click", ".h-stopProject", function () {
            modalDialog.showConfirmDialog(confirmStopProjectResources, function () {
                a4.callServerMethod(a4.getProjectAction("StopProject", "Home"), { projectId: projectId }, function (result) {
                    projectMenu.refresh();
                });
            }, 220, 500, false, { "project": projectMenu.project.Name, "count": projectMenu.project.ModulesCount });
        });

        projectMenu.context.on("click", ".h-marketSightSync", function () {
            if ($(this).hasClass('disabled'))
                return;

            modalDialog.showWindow(a4.getAction("PublishInMarketSight", "Analytics", "Home", {
                itemId: projectMenu.project.DatabaseId,
                itemStatus: projectMenu.project.Status,
                isProject: true
            }), 330, 625);
        });

        projectMenu.context.on("click", ".h-startProject", function () {
            modalDialog.showConfirmDialog(confirmActivateProjectResources, function () {
                a4.callServerMethod(a4.getProjectAction("StartProject", "Home"), { projectId: projectId }, function (result) {
                    projectMenu.refresh();
                });
            }, 220, 500, false, { "project": projectMenu.project.Name, "count": projectMenu.project.ModulesCount });
        });

        projectMenu.context.on("click", ".h-editProject", function () {
            modalDialog.showWindow(a4.getProjectAction("EditProject", "Home", { id: projectId }), 480, 850, { afterClose: projectMenu.refresh });
        });

        projectMenu.context.on("click", ".h-projectSelector", function () {
            if (projectMenu.projects.length == 0) {
                a4.callServerMethod(a4.getProjectAction("GetProjects", "Home"), { ignoreProject: projectId, moduleEnabled: $("#PageModuleEnabled").val() }, function (result) {
                    projectMenu.projects = result;
                    projectMenu.renderProjectSelector(projectMenu.projects);
                });
            }
        });

        projectMenu.context.on("keyup", ".h-projectSelector .h-search", function (e) {
            projectMenu.searchProjects($(this).val());
            return e.keyCode != 13;
        });
    },
    onBeforeRefresh: undefined,
    onAfterRefresh: undefined,
    refresh: function (callbackData) {
        if (typeof projectMenu.onBeforeRefresh === "function")
            projectMenu.onBeforeRefresh(callbackData);

        var controller = $("#survey-block", projectMenu.context).attr("data-controller");
        var action = $("#survey-block", projectMenu.context).attr("data-action");
        var projectId = projectMenu.getProjectId();

        a4.callServerMethod(a4.getProjectAction("GetMainHeader", "Shared"), { currentController: controller, currentAction: action, projectId: projectId },
            function (result) {
                if (result) {
                    $("#survey-block", projectMenu.context).replaceWith(result);
                    projectMenu.parseProject();
                }

                if (typeof projectMenu.onAfterRefresh === "function")
                    projectMenu.onAfterRefresh(callbackData);
            },
            function (error) { }
        );
    },
    searchProjects: function (value) {
        var matcher = new RegExp($.ui.autocomplete.escapeRegex(value), "i");

        var filteredProjects = _.filter(projectMenu.projects, function (p) { return matcher.test(p.Name) });

        projectMenu.renderProjectSelector(filteredProjects);
    },
    renderProjectSelector: function (projects) {
        var dropDown = $(".h-projectSelector .h-searchResults ul", projectMenu.context);
        var controller = $("#survey-block", projectMenu.context).attr("data-controller");
        var action = $("#survey-block", projectMenu.context).attr("data-action");

        $("li", dropDown).remove();

        _.each(projects, function (p) {
            dropDown.append($("<li />").append($("<a />", { "href": a4.getProjectAction(action, controller, { projectId: p.Id }) }).append(p.Name)));
        });

        dropDown.mCustomScrollbar("destroy");
        dropDown.mCustomScrollbar({ theme: "light-2", scrollInertia: 0 });
    }
}

$(document).ready(function () {
    projectMenu.bindEvents();
    projectMenu.parseProject();

    $(projectMenu).triggerHandler("ready");
});